<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

/** @noinspection PhpMultipleClassDeclarationsInspection */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Logger\Response\Assembler\LogItem;

use Stringable;
use XCart\Bundle\LogicBundle\Decorator\Logger\DTO\LogItem;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class LogItemAssembler implements LogItemAssemblerInterface
{
    private const DEFAULT_MESSAGE_TEMPLATE = 'Intercept {response-name} response of {request-name} request: {message}';

    public function __construct(
        private string $messageTemplate = self::DEFAULT_MESSAGE_TEMPLATE,
    ) {
    }

    public function assemble(RequestInterface $request, ResponseInterface $response): LogItem
    {
        $logItem = new LogItem();

        $data = [
            '{request-name}'  => get_class($request),
            '{response-name}' => get_class($response),
            '{message}'       => 'n/a',
        ];
        if ($response instanceof Stringable) {
            $data['{message}'] = (string)$response;
        }
        $logItem->message = strtr($this->messageTemplate, $data);

        $logItem->context = ['response' => (array)$response];

        return $logItem;
    }
}
