<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Logger\Request;

use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Logger\Request\Assembler\LogItem\LogItemAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class RequestLogger implements ActionInterface
{
    use LoggerAwareTrait;

    public function __construct(
        private ActionInterface $inner,
        LoggerInterface $logger,
        private LogItemAssemblerInterface $logItemAssembler,
    ) {
        $this->setLogger($logger);
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $logItem = $this->logItemAssembler->assemble($request);
        $this->logger->info($logItem->message, $logItem->context);

        return $this->inner->run($request);
    }
}
