<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Deduplicator;

use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Symfony\Component\Lock\LockFactory;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Decorator\Deduplicator\Assembler\Resource\ResourceAssemblerInterface;
use XCart\Bundle\LogicBundle\Decorator\Deduplicator\DTO\DeduplicationFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class Deduplicator implements ActionInterface
{
    use LoggerAwareTrait;

    public function __construct(
        private ActionInterface $inner,
        private LockFactory $lockFactory,
        private ResourceAssemblerInterface $resourceAssembler,
        LoggerInterface $logger,
    ) {
        $this->setLogger($logger);
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $resource = $this->resourceAssembler->assemble($request);
        $lock = $this->lockFactory->createLock($resource->id, $resource->ttl);

        if ($lock->acquire(true)) {
            $response = $this->inner->run($request);

            $lock->release();

            return $response;
        }

        $this->logger->info(
            'Deduplication failed. Request: {request_class}. Resource ID: {resource_id}',
            [
                'request_class' => get_class($request),
                'resource_id'   => $resource->id,
            ],
        );

        return new DeduplicationFailedResponse();
    }
}
