<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Deduplicator\Assembler\Resource;

use XCart\Bundle\CommonBundle\Assembler\DTOIdentifier\DTOIdentifierAssemblerInterface;
use XCart\Bundle\LogicBundle\Decorator\Deduplicator\DTO\Resource;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class IdBasedAssembler implements ResourceAssemblerInterface
{
    public function __construct(
        private DTOIdentifierAssemblerInterface $assembler,
        private ?float $ttl = null,
    ) {
    }

    public function assemble(RequestInterface $request): Resource
    {
        $resource = new Resource();
        $resource->id = $this->assembler->assemble($request);
        $resource->ttl = $this->ttl;

        return $resource;
    }
}
