<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Cacher\Preprocessor\CacheItem;

use DateInterval;
use Psr\Cache\CacheItemInterface;

class ExpiresAfterPreprocessor implements CacheItemPreprocessorInterface
{
    public function __construct(
        private DateInterval|int $interval,
    ) {
    }

    public function prepare(CacheItemInterface $item): void
    {
        $item->expiresAfter($this->interval);
    }
}
