<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Decorator\Cacher\Assembler\CacheItemKey;

use XCart\Bundle\CommonBundle\Assembler\DTOIdentifier\DTOIdentifierAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class IdBasedAssembler implements CacheItemKeyAssemblerInterface
{
    public function __construct(
        private DTOIdentifierAssemblerInterface $assembler,
    ) {
    }

    public function assemble(RequestInterface $request): string
    {
        return $this->assembler->assemble($request);
    }
}
