<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\LogicBundle\DTO\Response;

use Symfony\Component\Validator\Constraints as Assert;

trait PageOwnerTrait
{
    /**
     * @Assert\PositiveOrZero()
     */
    private ?int $pageIndex = null;

    /**
     * @Assert\Positive()
     */
    private ?int $itemsPerPage = null;

    /**
     * @Assert\PositiveOrZero()
     */
    private int $totalItems = 0;

    public function getPageIndex(): ?int
    {
        return $this->pageIndex;
    }

    public function setPageIndex(?int $pageIndex): static
    {
        $this->pageIndex = $pageIndex;

        return $this;
    }

    public function getItemsPerPage(): ?int
    {
        return $this->itemsPerPage;
    }

    public function setItemsPerPage(?int $itemsPerPage): static
    {
        $this->itemsPerPage = $itemsPerPage;

        return $this;
    }

    public function getTotalItems(): int
    {
        return $this->totalItems;
    }

    public function setTotalItems(int $totalItems): static
    {
        $this->totalItems = $totalItems;

        return $this;
    }
}
