<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request;

use Symfony\Component\Validator\Constraints as Assert;

trait Uuid4BasedRequestTrait
{
    #[Assert\Uuid(versions: [4])]
    private string $id;

    public function getId(): string
    {
        return $this->id;
    }

    public function setId(string $id): static
    {
        $this->id = $id;

        return $this;
    }
}
