<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request;

use Symfony\Component\Validator\Constraints as Assert;

trait PaginatorRequestTrait
{
    #[Assert\Positive]
    private ?int $pageIndex = null;

    #[Assert\Positive]
    private ?int $itemPerPage = null;

    public function getPageIndex(): ?int
    {
        return $this->pageIndex;
    }

    public function setPageIndex(?int $pageIndex): static
    {
        $this->pageIndex = $pageIndex;

        return $this;
    }

    public function getItemsPerPage(): ?int
    {
        return $this->itemPerPage;
    }

    public function setItemsPerPage(?int $itemPerPage): static
    {
        $this->itemPerPage = $itemPerPage;

        return $this;
    }
}
