<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request;

use JMS\Serializer\Annotation as JMS;
use Symfony\Component\Validator\Constraints as Assert;
use XCart\Bundle\CommonBundle\Validator\Constraints as XCartAssert;

trait OrderRequestTrait
{
    /**
     * @XCartAssert\All({@Assert\Choice({"ASC", "DESC", "asc", "desc"})})
     * @Assert\All({@Assert\Choice({"ASC", "DESC", "asc", "desc"})})
     * @JMS\Type("array<string,string>")
     */
    private array $orderByList = [];

    public function getOrderByList(): array
    {
        return $this->orderByList;
    }

    public function setOrderByList(array $orderByList): static
    {
        $this->orderByList = $orderByList;

        return $this;
    }
}
