<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request;

use Symfony\Component\Validator\Constraints as Assert;

trait MixedIdBasedRequestTrait
{
    /**
     * @var scalar
     */
    #[Assert\NotBlank]
    private mixed $id;

    /**
     * @return scalar
     */
    public function getId(): mixed
    {
        return $this->id;
    }

    /**
     * @param scalar $id
     */
    public function setId(mixed $id): static
    {
        $this->id = $id;

        return $this;
    }
}
