<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request\Filter\Value;

use Symfony\Component\Validator\Constraints as Assert;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\ListFilterStrategyType;

class IntegerListValue implements FilterValueInterface
{
    /**
     * @Assert\All({@Assert\Type("integer")})
     */
    private array $value;

    private ListFilterStrategyType $strategy;

    private bool $exclude = false;

    /**
     * @return float[]
     */
    public function getValue(): array
    {
        return $this->value;
    }

    /**
     * @param float[] $value
     */
    public function setValue(array $value): static
    {
        $this->value = $value;

        return $this;
    }

    public function getStrategy(): ListFilterStrategyType
    {
        return $this->strategy;
    }

    public function setStrategy(ListFilterStrategyType $strategy): static
    {
        $this->strategy = $strategy;

        return $this;
    }

    public function isExclude(): bool
    {
        return $this->exclude;
    }

    public function setExclude(bool $exclude): static
    {
        $this->exclude = $exclude;

        return $this;
    }
}
