<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\DTO\Request;

use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

trait CumulativeRequestTrait
{
    private ?ResponseInterface $previousResponse = null;

    public function getPreviousResponse(): ResponseInterface
    {
        return $this->previousResponse;
    }

    public function setPreviousResponse(ResponseInterface $previousResponse): static
    {
        $this->previousResponse = $previousResponse;

        return $this;
    }
}
