<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\ChainElement\Action\Collector;

use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class ResponsesCollector implements ResponsesCollectorInterface
{
    /** @var array ResponseInterface[] */
    private array $responses = [];

    public function collect(ResponseInterface $response): static
    {
        $this->responses[] = $response;

        return $this;
    }

    /**
     * @return ResponseInterface[]
     */
    public function getResponses(): array
    {
        return $this->responses;
    }
}
