<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\ChainElement\Action\Assembler\NextRequest;

use InvalidArgumentException;
use XCart\Bundle\LogicBundle\DTO\Request\CumulativeRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class CumulativeAssembler implements NextRequestAssemblerInterface
{
    /**
     * @param CumulativeRequestInterface  $request
     *
     * @return CumulativeRequestInterface
     */
    public function assemble(RequestInterface $request, ResponseInterface $response): RequestInterface
    {
        if (!($request instanceof CumulativeRequestInterface)) {
            throw new InvalidArgumentException(
                'CumulativeAssembler required "CumulativeRequestInterface" request'
            );
        }

        $request->setPreviousResponse($response);

        return $request;
    }
}
