<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\ChainElement\Action;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\ChainElement\Action\Assembler\NextRequest\NextRequestAssemblerInterface;
use XCart\Bundle\LogicBundle\ChainElement\Action\Collector\ResponsesCollectorInterface;
use XCart\Bundle\LogicBundle\ChainElement\Action\Exception\ActionChainException;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\FailedResponseInterface;

class ActionChainExceptionalElement implements ActionChainElementInterface
{
    public function __construct(
        private ActionInterface $action,
        private NextRequestAssemblerInterface $nextRequestAssembler,
        private ResponsesCollectorInterface $collector,
    ) {
    }

    /**
     * @throws ActionChainException
     */
    public function __invoke(RequestInterface $request): RequestInterface
    {
        return $this->run($request);
    }

    /**
     * @throws ActionChainException
     */
    public function run(RequestInterface $request): RequestInterface
    {
        $response = $this->action->run($request);
        $this->collector->collect($response);

        if ($response instanceof FailedResponseInterface) {
            throw new ActionChainException();
        }

        return $this->nextRequestAssembler->assemble($request, $response);
    }
}
