<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Assembler\Response;

use Throwable;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;

class ExceptionalFailedResponseAssembler implements ExceptionalFailedResponseAssemblerInterface
{
    public function __construct(
        private DefaultFailedResponseAssemblerInterface $failedResponseAssembler,
    ) {
    }

    public function assemble(Throwable $exception, ?string $detail = null, array ...$args): DefaultFailedResponse
    {
        if ($detail && $args) {
            $detail = sprintf($detail, ...$args);
        }

        return $this->failedResponseAssembler->assemble(
            DefaultFailedResponseAssemblerInterface::DEFAULT_TYPE,
            DefaultFailedResponseAssemblerInterface::DEFAULT_TITLE,
            $detail
                ? sprintf('%s : %s', $detail, $exception->getMessage())
                : $exception->getMessage(),
        );
    }
}
