<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Assembler\Response;

use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;

interface DefaultFailedResponseAssemblerInterface
{
    public const DEFAULT_TITLE = 'Internal error';
    public const DEFAULT_TYPE = '/errors/internal';

    public function assemble(string $type = self::DEFAULT_TYPE, string $title = self::DEFAULT_TITLE, ?string $detail = null): DefaultFailedResponse;
}
