<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Assembler\Response;

use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;

class DefaultFailedResponseAssembler implements DefaultFailedResponseAssemblerInterface
{
    public function __construct(
        private ResponseFactoryInterface $responseFactory,
    ) {
    }

    public function assemble(string $type = self::DEFAULT_TYPE, string $title = self::DEFAULT_TITLE, ?string $detail = null): DefaultFailedResponse
    {
        /** @var DefaultFailedResponse $response */
        $response = $this->responseFactory->create();

        return $response->setType($type)
            ->setTitle($title)
            ->setDetail($detail);
    }
}
