<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Workflow;

use Symfony\Component\Workflow\Workflow;
use Throwable;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Action\Workflow\Assembler\ResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\Workflow\Assembler\State\StateAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\Workflow\DecisionMaker\NextStepDecisionMakerInterface;
use XCart\Bundle\LogicBundle\Assembler\Response\ExceptionalFailedResponseAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class WorkflowBasedAction implements ActionInterface
{
    public function __construct(
        private Workflow $workflow,
        private StateAssemblerInterface $stateAssembler,
        private NextStepDecisionMakerInterface $nextStepDecisionMaker,
        private ResponseAssemblerInterface $responseAssembler,
        private ExceptionalFailedResponseAssemblerInterface $failedResponseAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $state = $this->stateAssembler->assemble($request);

        do {
            $list = $this->workflow->getEnabledTransitions($state);
            if (empty($list)) {
                break;
            }

            try {
                $this->workflow->apply($state, $list[0]->getName());
            } catch (Throwable $e) {
                return $this->failedResponseAssembler->assemble(
                    $e,
                    'cannot apply workflow "%s" with state object "%s"',
                    get_class($this->workflow),
                    $state,
                );
            }
        } while ($this->nextStepDecisionMaker->do($state));

        return $this->responseAssembler->assemble($state);
    }
}
