<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline\TransitionStrategy;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Action\Pipeline\DTO\TransitionDecision;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

interface TransitionStrategyInterface
{
    /**
     * @param ActionInterface[]   $actionsTail
     * @param ResponseInterface[] $responsesTail
     * @param RequestInterface[]  $requestsTail
     */
    public function makeDecision(array $actionsTail, array $responsesTail, array $requestsTail): TransitionDecision;
}
