<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline\TransitionStrategy;

use XCart\Bundle\LogicBundle\Action\Pipeline\Assembler\NextRequest\NextRequestAssemblerInterface;
use XCart\Bundle\LogicBundle\Action\Pipeline\DTO\TransitionDecision;
use XCart\Bundle\LogicBundle\DTO\Response\FailedResponseInterface;

class AndTransitionStrategy implements TransitionStrategyInterface
{
    public function __construct(
        private NextRequestAssemblerInterface $nextRequestAssembler,
    ) {
    }

    public function makeDecision(array $actionsTail, array $responsesTail, array $requestsTail): TransitionDecision
    {
        $lastResponse = end($responsesTail);
        if ($lastResponse instanceof FailedResponseInterface) {
            return (new TransitionDecision())
                ->setResponse($lastResponse);
        }

        return (new TransitionDecision())
            ->setNextActionRequest($this->nextRequestAssembler->assemble($actionsTail, $responsesTail, $requestsTail))
            ->setResponse($lastResponse);
    }
}
