<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline;

use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\Action\Pipeline\TransitionStrategy\TransitionStrategyInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

/**
 * @property iterable<int,ActionInterface> $actions
 */
class PipelineAction implements ActionInterface
{
    public function __construct(
        private iterable $actions,
        private TransitionStrategyInterface $transitionStrategy,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $actionsTail = [];
        $responsesTail = [];
        $requestsTail = [];

        $currentRequest = $request;
        $currentResponse = null;

        foreach ($this->actions as $action) {
            $currentResponse = $action($currentRequest);

            $actionsTail[] = $action;
            $responsesTail[] = $currentResponse;
            $requestsTail[] = $currentRequest;

            $decision = $this->transitionStrategy->makeDecision($actionsTail, $responsesTail, $requestsTail);
            if (!$decision->getNextActionRequest()) {
                return $decision->getResponse();
            }

            $currentRequest = $decision->getNextActionRequest();
        }

        return $currentResponse ?: (new DefaultFailedResponse())
            ->setTitle('Pipeline is empty');
    }
}
