<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline\DTO;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

class TransitionDecision
{
    private ?RequestInterface $nextActionRequest = null;

    private ResponseInterface $response;

    public function getNextActionRequest(): ?RequestInterface
    {
        return $this->nextActionRequest;
    }

    public function setNextActionRequest(?RequestInterface $nextActionRequest): TransitionDecision
    {
        $this->nextActionRequest = $nextActionRequest;

        return $this;
    }

    public function getResponse(): ResponseInterface
    {
        return $this->response;
    }

    public function setResponse(ResponseInterface $response): TransitionDecision
    {
        $this->response = $response;

        return $this;
    }
}
