<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline\DTO;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;

interface CumulativeRequestInterface extends RequestInterface
{
    /**
     * @return ResponseInterface[]
     */
    public function getPreviousResponses(): array;

    /**
     * @param ResponseInterface[] $responses
     */
    public function setPreviousResponses(array $responses): static;
}
