<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\LogicBundle\Action\Pipeline\Assembler\NextRequest;

use InvalidArgumentException;
use XCart\Bundle\LogicBundle\Action\Pipeline\DTO\CumulativeRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class CumulativeAssembler implements NextRequestAssemblerInterface
{
    public function assemble(array $actionsTail, array $responsesTail, array $requestsTail): RequestInterface
    {
        $request = $requestsTail[0];
        if (!($request instanceof CumulativeRequestInterface)) {
            throw new InvalidArgumentException(
                'CumulativeAssembler required "CumulativeRequestInterface" first request in pipeline'
            );
        }

        $request->setPreviousResponses($responsesTail);

        return $request;
    }
}
