# Logic Bundle

## Introduction

This bundle is a part of the API First programming approach for the XCart

## Development

If some changes are needed to be applied to this bundle it is required to:
- create new branch with the name in common pattern (`{developer-name}/{task-id}_@{parant-branch-name}`).
- declare branch_alias in `composer.json` file:
```json
{

  "extra": {
    "branch-alias": {
      "{branch-name}": "{version-alias}"
    }

  }

}
```
For example:
Branch name: `developer/ECOM-123_@5.5.1.x`
Version alias: `123.x-dev`
```json
{

  "extra": {
    "branch-alias": {
      "developer/ECOM-123_@5.5.1.x": "123.x-dev"
    }

  }

}

```

After that the string `123.x@dev` can be used as the version in client library or application:
```shell
composer require "xcart/logic-bundle:123.x@dev"
```
