<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\AllEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\EntityInterface;

class ServiceLocatorsRegister
{
    public function __construct(private NameResolverInterface $nameResolver)
    {
    }

    public function register(ContainerBuilder $container, DataProvider $dataProvider): void
    {
        // Factories
        $hash = [];

        /** @var EntityInterface $entity */
        foreach ($dataProvider as $entity) {
            $hash[$entity->className] = new Reference(
                $this->nameResolver->buildFactoryInterfaceName($entity->className)
            );
        }

        $container->getDefinition('xcart.dto_generator.service_locator.factories')
            ->setArgument(0, $hash);
    }
}
