<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service;

use Twig\Environment;
use Twig\Loader\FilesystemLoader;

class Renderer implements RendererInterface
{
    private Environment $twig;

    public function __construct()
    {
        $loader = new FilesystemLoader(__DIR__ . '/../Resources/templates');
        $this->twig = new Environment($loader);
    }

    public function render(string $template, array $arguments): string
    {
        return $this->twig->load($template)->render($arguments);
    }
}
