<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service;

use RuntimeException;

class Preparer
{
    public function prepare(string $directory): void
    {
        $this->clearDirectory($directory);

        // Fix for Doctrine
        $this->createDirectory($directory . '/Entity');

        // Fix for API platform
        $this->createDirectory($directory . '/API/Entity');
    }

    private function clearDirectory(string $path): void
    {
        if (!file_exists($path) && !mkdir($path, 0777, true) && !is_dir($path)) {
            throw new RuntimeException(sprintf('Directory "%s" was not created', $path));
        }

        $files = array_diff(scandir($path), ['.', '..']);
        foreach ($files as $file) {
            if (is_dir($path . '/' . $file)) {
                $this->clearDirectory($path . '/' . $file);
            } else {
                unlink($path . '/' . $file);
            }
        }

        rmdir($path);
    }

    private function createDirectory(string $dir): void
    {
        if (!file_exists($dir) && !mkdir($dir, 0777, true) && !is_dir($dir)) {
            throw new RuntimeException(sprintf('Directory "%s" was not created', $dir));
        }
    }
}
