<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\PostProcessor;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Enumeration;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\EnumerationsDataProvider as DataProvider;

class EnumerationPostProcessor
{
    public function normalize(DataProvider $dataProvider): void
    {
        /** @var Enumeration $entity */
        foreach ($dataProvider as $entity) {
            $items = [];
            foreach ($entity->items as $key => $value) {
                $key = strtoupper($key);
                $items[$key] = $value;
            }

            $entity->items = $items;
        }
    }
}
