<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Normalizer;

use DateTime;
use DateTimeImmutable;
use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerNullableInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerNullableTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdIntegerTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4Interface;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4NullableInterface;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4NullableTrait;
use XCart\Bundle\CommonBundle\DTO\Id\IdUUID4Trait;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\LogicEntitiesDataProvider as DataProvider;
use XCart\Bundle\DTOGeneratorBundle\Service\Normalizer\EntityProcessor\EntityProcessorInterface;

/**
 * @property iterable<int,EntityProcessorInterface> $processors
 */
class LogicEntityNormalizer implements NormalizerInterface
{
    public function __construct(
        private DataProvider $dataProvider,
        private iterable $processors,
    ) {
    }

    public function normalize(): void
    {
        /** @var Entity $entity */
        foreach ($this->dataProvider as $entity) {
            $this->normalizeEntity($entity);
        }
    }

    private function normalizeEntity(Entity $entity): void
    {
        $entity->uses[] = DateTime::class;
        $entity->uses[] = DateTimeImmutable::class;

        if ($entity->new) {
            switch ($entity->idType) {
                case $entity::ID_TYPE_INT:
                    $entity->interfaces[] = IdIntegerNullableInterface::class;
                    $entity->traits[] = IdIntegerNullableTrait::class;
                    break;

                case $entity::ID_TYPE_UUID4:
                    $entity->interfaces[] = IdUUID4NullableInterface::class;
                    $entity->traits[] = IdUUID4NullableTrait::class;
                    break;
            }
        } else {
            switch ($entity->idType) {
                case $entity::ID_TYPE_INT:
                    $entity->interfaces[] = IdIntegerNullableInterface::class;
                    $entity->traits[] = IdIntegerNullableTrait::class;
                    break;

                case $entity::ID_TYPE_UUID4:
                    $entity->interfaces[] = IdUUID4NullableInterface::class;
                    $entity->traits[] = IdUUID4NullableTrait::class;
                    break;
            }
        }

        foreach ($this->processors as $processor) {
            $processor->process($entity);
        }
    }
}
