<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Normalizer\EntityProcessor;

use ApiPlatform\Core\Annotation\ApiProperty;
use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Annotation;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Field;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Enumeration;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\EnumerationsDataProvider;

class MarkEnum implements EntityProcessorInterface
{
    public function __construct(
        private EnumerationsDataProvider $enumerationsDataProvider,
    )
    {
    }

    public function process(AbstractEntity $entity): void
    {
        $hasApiProperty = false;
        /** @var Field $field */
        foreach ($entity->fields as $field) {
            $enumeration = $this->findEnumeration($field);
            if (!$enumeration) {
                continue;
            }

            $field->annotations->addAnnotationFromArray(
                [
                    'openapiContext' => [
                        'type' => 'string',
                        'enum' => array_values($enumeration->items),
                    ],
                ],
                'ApiProperty',
            );

            $hasApiProperty = true;
        }

        if ($hasApiProperty) {
            $entity->uses[] = ApiProperty::class;
        }
    }

    private function findEnumeration(Field $field): ?Enumeration
    {
        if (!ClassNameAssembler::isFullClassName($field->type)) {
            return null;
        }

        /** @var Enumeration $enumeration */
        foreach ($this->enumerationsDataProvider as $enumeration) {
            if ($enumeration->className === $field->type) {
                return $enumeration;
            }
        }

        return null;
    }
}
