<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Normalizer\EntityProcessor;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Annotation;

class AddJMSUse implements EntityProcessorInterface
{
    public function process(AbstractEntity $entity): void
    {
        foreach ($entity->fields as $field) {
            /** @var Annotation $annotation */
            foreach ($field->annotations as $annotation) {
                if (preg_match('/^JMS\\\\/S', $annotation->name)) {
                    $entity->uses[] = 'JMS\Serializer\Annotation as JMS';
                    return;
                }
            }
        }
    }
}
