<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Normalizer\EntityProcessor;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Field;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\EnumerationsDataProvider;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Enumeration as EnumEntity;

class AddJMSType implements EntityProcessorInterface
{
    public function __construct(
        private EnumerationsDataProvider $enumerationsDataProvider,
    )
    {
    }

    public function process(AbstractEntity $entity): void
    {
        /** @var Field $field */
        foreach ($entity->fields as $field) {
            if ($field->annotations->hasAnnotation('JMS\Type')) {
                continue;
            }

            switch ($field->type) {
                case 'string':
                case 'boolean':
                case 'bool':
                case 'int':
                case 'integer':
                case 'float':
                case 'array':
                case 'iterable':
                    $field->annotations->addAnnotationFromArray([$field->type], 'JMS\Type');
                    continue 2;
            }

            if (ClassNameAssembler::isFullClassName($field->type)) {
                if ($this->isEnum($field->type)) {
                    $field->annotations->addAnnotationFromArray(['enum<' . $field->type . '>'], 'JMS\Type');
                    continue;
                }

                $field->annotations->addAnnotationFromArray([$field->type], 'JMS\Type');
                continue;
            }

            if (str_ends_with($field->type, '[]')) {
                $arrayType = substr($field->type, 0, -2);
                $field->annotations->addAnnotationFromArray(['array<' . $arrayType . '>'], 'JMS\Type');
            }
        }
    }

    /**
     * @param class-string $className
     */
    private function isEnum(string $className): bool
    {
        /** @var EnumEntity $enum */
        foreach ($this->enumerationsDataProvider as $enum) {
            if ($enum->className === $className) {
                return true;
            }
        }

        return false;
    }
}
