<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Normalizer\EntityProcessor;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DTO\GeneratedDTOInterface;

class AddCommonInterface implements EntityProcessorInterface
{
    public function process(AbstractEntity $entity): void
    {
        if (!($entity instanceof DTO) || !$entity->trait) {
            $entity->interfaces[] = GeneratedDTOInterface::class;
        }
    }
}
