<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer;
use XCart\Bundle\DTOGeneratorBundle\Enum\LogicRequestType;
use XCart\Bundle\DTOGeneratorBundle\Enum\LogicResponseType;

interface NameResolverInterface
{
    public function buildCollectionClassName(string $className): string;

    public function buildFactoryClassName(string $className): string;

    public function buildFactoryInterfaceName(string $className): string;

    public function buildTransformerClassName(Transformer $entity): string;

    public function buildTransformerInterfaceName(Transformer $entity): string;

    public function buildNewEntityClassName(string $className): string;

    public function buildLogicRequestClassName(string $className, LogicRequestType $type): string;

    public function buildLogicResponseClassName(string $className, LogicResponseType $type): string;

    public function buildRepositoryClassName(string $className): string;

    public function buildRepositoryReadId(string $className): string;

    public function buildRepositoryWriteId(string $className): string;

    public function buildDataSourceReadClassName(string $className): string;

    public function buildDataSourceWriteClassName(string $className): string;

    public function buildDataSourceReadId(string $className): string;

    public function buildDataSourceWriteId(string $className): string;

    public function buildDataSourceReadInterfaceName(string $className): string;

    public function buildDataSourceWriteInterfaceName(string $className): string;

    public function buildDoctrineGetListCriteriaAssemblerId(LogicEntity $entity): string;

    public function buildDoctrineFilterTransformerId(LogicEntity|DTO $entity): string;

    public function buildDoctrineOrderRuleTransformerId(LogicEntity|DTO $entity): string;

    public function buildQueryBuilderClassName(string $className): string;

    public function buildQueryBuilderFactoryReadID(string $className): string;

    public function buildQueryBuilderFactoryWriteID(string $className): string;

    public function buildQueryBuilderInterfaceName(string $className): string;

    public function buildQueryBuilderReadInterfaceName(string $className): string;

    public function buildQueryBuilderWriteInterfaceName(string $className): string;

    public function buildRepositoryReadInterfaceName(string $className): string;

    public function buildRepositoryWriteInterfaceName(string $className): string;

    public function buildAPIGetOneDataProviderId(string $className): string;

    public function buildAPIGetOneRequestAssemblerId(string $className): string;

    public function buildAPIGetOneResponseAssemblerId(string $className): string;

    public function buildAPIGetCollectionDataProviderId(string $className): string;

    public function buildAPIGetCollectionRequestAssemblerId(string $className): string;

    public function buildAPIGetCollectionRequestPaginationEnricherId(string $className): string;

    public function buildAPIGetCollectionRequestFilterAssemblerId(string $className): string;

    public function buildAPIGetCollectionRequestOrderRuleAssemblerId(string $className): string;

    public function buildAPIGetCollectionResponseAssemblerId(string $className): string;

    public function buildAPIDataPersisterId(string $className): string;

    public function buildAPIPersisterId(string $className): string;

    public function buildAPIPersisterCreateRequestAssemblerId(string $className): string;

    public function buildAPIPersisterUpdateRequestAssemblerId(string $className): string;

    public function buildAPIPersisterCreateResponseAssemblerId(string $className): string;

    public function buildAPIPersisterUpdateResponseAssemblerId(string $className): string;

    public function buildAPIRemoverId(string $className): string;

    public function buildAPIRemoverRequestAssemblerId(string $className): string;

    public function buildLogicGetOneId(string $className): string;

    public function buildLogicGetOneEntityIdAssemblerId(string $className): string;

    public function buildLogicGetOneResponseAssemblerId(string $className): string;

    public function buildLogicGetCollectionId(string $className): string;

    public function buildLogicGetCollectionResponseAssemblerId(string $className): string;

    public function buildLogicCreateOneId(string $className): string;

    public function buildLogicCreateOneEntityAssemblerId(string $className): string;

    public function buildLogicCreateOneResponseAssemblerId(string $className): string;

    public function buildLogicUpdateOneId(string $className): string;

    public function buildLogicUpdateOneEntityEnricherId(string $className): string;

    public function buildLogicUpdateOneEntityInternalEnricherId(string $className): string;

    public function buildLogicUpdateOneResponseAssemblerId(string $className): string;

    public function buildLogicDeleteOneId(string $className): string;

    public function buildLogicDeleteOneArgumentsAssemblerId(string $className): string;

    public function buildLogicDeleteOneResponseAssemblerId(string $className): string;

    public function buildLogicEntityFilterClassName(string $className): string;

    public function buildLogicEntityOrderRuleClassName(string $className): string;

    public function buildDoctrineGetListFilterClassName(LogicEntity $entity): string;

    public function buildDoctrineGetListOrderRuleClassName(LogicEntity $entity): string;
}
