<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Generator;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTOInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer as TransformerEntity;
use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerType;

class TransformerInterface extends AbstractGenerator
{
    /**
     * @param TransformerEntity $entity
     */
    protected function getClassName(DTOInterface $entity): string
    {
        return $this->nameResolver->buildTransformerInterfaceName($entity);
    }

    /**
     * @param TransformerEntity $entity
     */
    protected function getTemplate(DTOInterface $entity): string
    {
        if ($entity->type?->getValue() === TransformerType::LOGIC_RESPONSE_COLLECTION_PAYLOAD) {
            return 'transformer_logic_response_collection_payload_interface.php.twig';
        }

        return 'transformer_interface.php.twig';
    }
}
