<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Generator;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTOInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer as TransformerEntity;
use XCart\Bundle\DTOGeneratorBundle\Enum\TransformerType;

class Transformer extends AbstractGenerator
{
    protected function generateEntity(string $directory, string $namespace, DTOInterface $entity): void
    {
        /** @var TransformerEntity $entity */
        if ($entity->pattern->isPreDefined()) {
            return;
        }

        parent::generateEntity($directory, $namespace, $entity);
    }

    /**
     * @param TransformerEntity $entity
     */
    protected function getClassName(DTOInterface $entity): string
    {
        return $this->nameResolver->buildTransformerClassName($entity);
    }

    /**
     * @param TransformerEntity $entity
     */
    protected function getTemplate(DTOInterface $entity): string
    {
        if ($entity->type?->getValue() === TransformerType::LOGIC_RESPONSE_COLLECTION_PAYLOAD && !$entity->toEntity) {
            return 'transformer_logic_response_collection_payload_factoryless.php.twig';
        }

        if ($entity->type?->getValue() === TransformerType::LOGIC_RESPONSE_ITEM_PAYLOAD && !$entity->toEntity) {
            return 'transformer_logic_response_item_payload_factoryless.php.twig';
        }

        if ($entity->type) {
            return match ($entity->type->getValue()) {
                TransformerType::LOGIC_RESPONSE_ITEM_PAYLOAD       => 'transformer_logic_response_item_payload.php.twig',
                TransformerType::LOGIC_RESPONSE_COLLECTION_PAYLOAD => 'transformer_logic_response_collection_payload.php.twig',
                TransformerType::LOGIC_REQUEST_ITEM_PAYLOAD        => 'transformer_logic_request_item_payload.php.twig',
                default                                            => 'transformer.php.twig',
            };
        }

        if ($entity->pattern->isDirect() || $entity->pattern->isDirectTo()) {
            return 'transformer_direct.php.twig';
        }

        if ($entity->pattern->isDirectFrom()) {
            return 'transformer_direct_from.php.twig';
        }

        return 'transformer.php.twig';
    }
}
