<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Generator;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTOInterface;

class QueryBuilderInterfaceGenerator extends AbstractGenerator
{
    /**
     * @param Entity $entity
     */
    protected function getClassName(DTOInterface $entity): string
    {
        return $this->nameResolver->buildQueryBuilderInterfaceName($entity->className);
    }

    /**
     * @param Entity $entity
     */
    protected function getTemplate(DTOInterface $entity): string
    {
        return 'query_builder_interface.php.twig';
    }
}
