<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Generator\Entity;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTOInterface;
use XCart\Bundle\DTOGeneratorBundle\Service\Generator\AbstractGenerator;

class DoctrineEntity extends AbstractGenerator
{
    /**
     * @param Entity $entity
     */
    protected function getClassName(DTOInterface $entity): string
    {
        return $entity->className;
    }

    /**
     * @param Entity $entity
     */
    protected function getTemplate(DTOInterface $entity): string
    {
        return 'entity/doctrine_entity.php.twig';
    }
}
