<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\Generator;

use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\AbstractEntity as Entity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTOInterface;

class Collection extends AbstractGenerator
{
    /**
     * @param Entity $entity
     */
    protected function getClassName(DTOInterface $entity): string
    {
        return $this->nameResolver->buildCollectionClassName($entity->className);
    }

    /**
     * @param Entity $entity
     */
    protected function getTemplate(DTOInterface $entity): string
    {
        return 'collection.php.twig';
    }
}
