<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Transformer;

class TransformerInterfaceDataBuilder extends AbstractDataBuilder
{
    /**
     * @param Transformer $entity
     */
    public function build($entity): array
    {
        $className = $this->nameResolver->buildTransformerClassName($entity);
        $interfaceName = $this->nameResolver->buildTransformerInterfaceName($entity);

        return [
            'namespace'          => ClassNameAssembler::assembleNamespace($className),
            'classNameShort'     => ClassNameAssembler::assembleShortName($className),
            'interfaceNameShort' => ClassNameAssembler::assembleShortName($interfaceName),
            'fromClassName'      => $entity->from,
            'fromClassNameShort' => ClassNameAssembler::assembleShortName($entity->from),
            'toClassName'        => $entity->to,
            'toClassNameShort'   => ClassNameAssembler::assembleShortName($entity->to),
        ];
    }
}
