<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class RepositoryWriteInterfaceDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildRepositoryWriteInterfaceName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => array_merge(
                [WriteRepositoryInterface::class],
                [$entity->className . ' as Entity']
            ),
        ];
    }
}
