<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class RepositoryDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildRepositoryClassName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => array_merge(
                $entity->repository->uses,
                [$entity->className . ' as Entity']
            ),
            'interfaces'     => $entity->repository->interfaces,
            'extends'        => $entity->repository->extends,
            'traits'         => $entity->repository->traits,
        ];
    }
}
