<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity as Entity;

class QueryBuilderDataBuilder extends AbstractDataBuilder
{
    public function build(Entity $entity): array
    {
        $className = $this->nameResolver->buildQueryBuilderClassName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'uses'           => $entity->queryBuilder->uses,
            'interfaces'     => $entity->queryBuilder->interfaces,
            'extends'        => $entity->queryBuilder->extends,
            'traits'         => $entity->queryBuilder->traits,
        ];
    }
}
