<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\HashMap as Entity;

class HashMapDataBuilder extends AbstractDataBuilder
{
    /**
     * @param Entity $entity
     */
    public function build($entity): array
    {
        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($entity->className),
            'classNameShort' => ClassNameAssembler::assembleShortName($entity->className),
            'keyType'        => $entity->keyType,
            'valueType'      => $entity->valueType,
        ];
    }
}
