<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\APIEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicRequestEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicResponseEntity;
use XCart\Bundle\CommonBundle\Factory\GeneratedFactoryInterface;
use XCart\Bundle\LogicBundle\Factory\Request\RequestFactoryInterface;
use XCart\Bundle\LogicBundle\Factory\Response\ResponseFactoryInterface;

class FactoryInterfaceDataBuilder extends AbstractDataBuilder
{
    /**
     * @param APIEntity|DoctrineEntity|LogicEntity|LogicRequestEntity|LogicResponseEntity|DTO $entity
     */
    public function build($entity): array
    {
        $uses = [
            $entity->className . ' as DTO',
            GeneratedFactoryInterface::class,
        ];
        $interfaces = $entity->factory->interfaces;
        foreach ($interfaces as $k => $className) {
            if (str_contains($className, '\\')) {
                $uses[] = $className;
                $interfaces[$k] = ClassNameAssembler::assembleShortName($className);
            }
        }
        $interfaces[] = 'GeneratedFactoryInterface';

        if ($entity instanceof LogicRequestEntity) {
            $uses[] = RequestFactoryInterface::class;
            $interfaces[] = 'RequestFactoryInterface';
        } elseif ($entity instanceof LogicResponseEntity) {
            $uses[] = ResponseFactoryInterface::class;
            $interfaces[] = 'ResponseFactoryInterface';
        }

        $interfaceName = $this->nameResolver->buildFactoryInterfaceName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($interfaceName),
            'classNameShort' => ClassNameAssembler::assembleShortName($interfaceName),
            'interfaces'     => $interfaces,
            'uses'           => $uses,
        ];
    }
}
