<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\APIEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DoctrineEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\DTO;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicRequestEntity;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\LogicResponseEntity;

class FactoryDataBuilder extends AbstractDataBuilder
{
    /**
     * @param APIEntity|DoctrineEntity|LogicEntity|LogicRequestEntity|LogicResponseEntity|DTO $entity
     */
    public function build($entity): array
    {
        $className = $this->nameResolver->buildFactoryClassName($entity->className);
        $interfaceName = $this->nameResolver->buildFactoryInterfaceName($entity->className);

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($className),
            'classNameShort' => ClassNameAssembler::assembleShortName($className),
            'interfaces'     => [ClassNameAssembler::assembleShortName($interfaceName)],
            'uses'           => array_merge(
                $entity->factory->uses,
                [
                    $entity->className . ' as DTO',
                ]
            ),
        ];
    }
}
