<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\DTOGeneratorBundle\Service\GenerationDataBuilder;

use XCart\Bundle\CommonBundle\Assembler\ClassNameAssembler;
use XCart\Bundle\CommonBundle\Assembler\MethodNameAssembler;
use XCart\Bundle\DTOGeneratorBundle\DataProvider\DTO\Enumeration;

class EnumerationDataBuilder extends AbstractDataBuilder
{
    /**
     * @param Enumeration $entity
     */
    public function build($entity): array
    {
        $items = [];
        foreach ($entity->items as $key => $value) {
            $items[] = [
                'key'       => $key,
                'value'     => $value,
                'issetName' => 'is' . MethodNameAssembler::convertUnderscoreToCamelCase(strtolower($key)),
                'is_string' => is_string($value),
            ];
        }

        return [
            'namespace'      => ClassNameAssembler::assembleNamespace($entity->className),
            'classNameShort' => ClassNameAssembler::assembleShortName($entity->className),
            'items'          => $items,
        ];
    }
}
